/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.ui.bonsai.earth;

import com.ibm.hwmca.fw.servlet.util.HMCSession;
import com.ibm.hwmca.fw.ui.UIInfo;
import com.ibm.hwmca.fw.ui.UIObjectProperties;
import com.ibm.hwmca.fw.ui.UIObjectsReader;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.ui.bonsai.config.BonsaiConfigException;
import com.ibm.hwmca.ui.bonsai.config.TaskRetrieverConfigBean;
import com.ibm.hwmca.ui.bonsai.earth.BonsaiTreeNode;
import com.ibm.hwmca.ui.bonsai.earth.Targetable;
import com.ibm.hwmca.ui.bonsai.earth.TaskContainerNode;
import com.ibm.hwmca.ui.bonsai.earth.TaskNode;
import com.ibm.hwmca.ui.bonsai.earth.util.TaskRetrieverInterface;
import com.ibm.hwmca.ui.bonsai.servlet.ControllerServlet;
import com.ibm.hwmca.ui.bonsai.servlet.util.TaskUrl;
import com.ibm.hwmca.ui.bonsai.servlet.util.UISession;
import com.ibm.hwmca.ui.bonsai.util.SortedList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TaskManager {
    private static final String TRACEMASK_T = "XBUITKMT";
    private static final String TRACEMASK_F = "XBUITKMF";
    private static final String TRACEMASK_D = "XBUITKMD";
    private static final String NODE_CLUSTERS_SESSION_KEY = "task_sets";
    private static TaskManager taskManager;
    private static final Object LOCK;
    private List rootNodes;
    private Map retrievers;

    private TaskManager(List taskRetrieverConfigBeans) throws BonsaiConfigException {
        Trace.trace(TRACEMASK_F, "> TaskManager(" + taskRetrieverConfigBeans + ")");
        this.retrievers = new HashMap(taskRetrieverConfigBeans.size());
        TaskRetrieverConfigBean configBean = null;
        TaskRetrieverInterface taskRetriever = null;
        Iterator i = taskRetrieverConfigBeans.iterator();
        while (i.hasNext()) {
            configBean = (TaskRetrieverConfigBean)i.next();
            try {
                taskRetriever = (TaskRetrieverInterface)Class.forName(configBean.getClassName()).newInstance();
            }
            catch (Exception ex) {
                // empty catch block
            }
            taskRetriever.init(configBean.getKey(), configBean.getParameters());
            this.retrievers.put(configBean.getKey(), taskRetriever);
        }
        UIObjectsReader reader = ControllerServlet.getUIObjectsReader();
        Set rootTaskShortIds = reader.getRootTaskShortIds(false);
        this.rootNodes = new SortedList(TaskNode.getTaskNodeComparator());
        String id = null;
        boolean isTask = false;
        byte[] props = null;
        Iterator i2 = rootTaskShortIds.iterator();
        while (i2.hasNext()) {
            id = (String)i2.next();
            props = reader.getBuffer(id);
            isTask = UIObjectProperties.isTask(props);
            this.rootNodes.add(new TaskNode(id, new UIInfo(UIObjectProperties.getName(props), UIObjectProperties.getCaption(props), UIObjectProperties.getImageName(props)), isTask, isTask ? new TaskUrl(id, 2) : null));
        }
        this.buildFullTaskTree(this.rootNodes, reader);
        Trace.trace(TRACEMASK_F, "< TaskManager()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(List taskRetrieverConfigBeans) throws BonsaiConfigException {
        Trace.trace(TRACEMASK_T, "<--> TaskManager.init(" + taskRetrieverConfigBeans + ")");
        Object object = LOCK;
        synchronized (object) {
            if (taskManager == null) {
                taskManager = new TaskManager(taskRetrieverConfigBeans);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TaskManager getTaskManager() {
        Object object = LOCK;
        synchronized (object) {
            return taskManager;
        }
    }

    public TaskRetrieverInterface getTaskRetriever(String key) {
        return (TaskRetrieverInterface)this.retrievers.get(key);
    }

    public List getFullTaskTree() {
        return this.rootNodes;
    }

    public String getDefaultTaskUrl(BonsaiTreeNode node) {
        Targetable target = null;
        if (!(node instanceof Targetable) || !(target = (Targetable)((Object)node)).hasDefaultTask()) {
            return null;
        }
        return new TaskUrl(target.getShortId(), target.getParentShortId()).toString();
    }

    public void clearTasks(UISession session) {
        session.setResourceTaskTrees(null);
        session.getHMCSession().removeSessionAttribute(NODE_CLUSTERS_SESSION_KEY);
    }

    public boolean updateTasks(List formerSelectedNodes, List newSelectedNodes, UISession session) {
        boolean updateRequired = false;
        HMCSession hmcSession = session.getHMCSession();
        ArrayList nodeClusters = (ArrayList)hmcSession.getSessionAttribute(NODE_CLUSTERS_SESSION_KEY);
        if (nodeClusters == null) {
            nodeClusters = new ArrayList();
            hmcSession.setSessionAttribute(NODE_CLUSTERS_SESSION_KEY, nodeClusters);
        }
        ArrayList deselectedNodes = new ArrayList(formerSelectedNodes);
        deselectedNodes.removeAll(newSelectedNodes);
        Set cluster = null;
        TaskContainerNode node = null;
        Iterator i = deselectedNodes.iterator();
        block0: while (i.hasNext()) {
            node = (TaskContainerNode)i.next();
            Iterator j = nodeClusters.iterator();
            while (j.hasNext()) {
                cluster = (Set)j.next();
                if (!cluster.remove(node)) continue;
                if (!cluster.isEmpty()) continue block0;
                j.remove();
                updateRequired = true;
                continue block0;
            }
        }
        ArrayList selectedNodes = new ArrayList(newSelectedNodes);
        selectedNodes.removeAll(formerSelectedNodes);
        Iterator i2 = selectedNodes.iterator();
        while (i2.hasNext()) {
            node = (TaskContainerNode)i2.next();
            boolean foundNodesCluster = false;
            Iterator j = nodeClusters.iterator();
            while (j.hasNext() && !foundNodesCluster) {
                cluster = (Set)j.next();
                if (!((TaskContainerNode)cluster.iterator().next()).guaranteesSameTaskSet(node)) continue;
                cluster.add(node);
                foundNodesCluster = true;
            }
            if (foundNodesCluster) continue;
            HashSet<TaskContainerNode> newCluster = new HashSet<TaskContainerNode>();
            newCluster.add(node);
            nodeClusters.add(newCluster);
            updateRequired = true;
        }
        if (!updateRequired) {
            return false;
        }
        ArrayList clusterRepresentativeNodes = new ArrayList(nodeClusters.size());
        Iterator i3 = nodeClusters.iterator();
        while (i3.hasNext()) {
            clusterRepresentativeNodes.add(((Set)i3.next()).iterator().next());
        }
        session.setResourceTaskTrees(this.getTasks(clusterRepresentativeNodes, session));
        return true;
    }

    public List getTasks(List selectedNodes, UISession session) {
        Iterator i = selectedNodes.iterator();
        if (!i.hasNext()) {
            return new ArrayList(0);
        }
        List tasks = this.getTasks((TaskContainerNode)i.next(), session);
        while (i.hasNext()) {
            tasks = this.intersectTaskTrees(tasks, this.getTasks((TaskContainerNode)i.next(), session));
        }
        return tasks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getTasks(TaskContainerNode selectedNode, UISession session) {
        Object object = LOCK;
        synchronized (object) {
            return selectedNode.getTasks(session);
        }
    }

    public List getTasksWithTargets(List selectedNodes, UISession session) {
        List tasks = this.getTasks(selectedNodes, session);
        ArrayList<String> targetIds = new ArrayList<String>(selectedNodes.size());
        String parentId = null;
        Targetable target = null;
        Iterator i = selectedNodes.iterator();
        while (i.hasNext()) {
            target = (Targetable)i.next();
            targetIds.add(target.getShortId());
            if (parentId != null) continue;
            parentId = target.getParentShortId();
        }
        this.setTaskTargets(tasks, targetIds, parentId);
        return tasks;
    }

    public List getTasksWithTargets(TaskContainerNode selectedNode, UISession session) {
        List tasks = this.getTasks(selectedNode, session);
        Targetable target = (Targetable)((Object)selectedNode);
        ArrayList<String> targetIds = new ArrayList<String>(1);
        targetIds.add(target.getShortId());
        this.setTaskTargets(tasks, targetIds, target.getParentShortId());
        return tasks;
    }

    private void buildFullTaskTree(List nodes, UIObjectsReader reader) {
        TaskNode node = null;
        String id = null;
        boolean isTask = false;
        byte[] props = null;
        Iterator i = nodes.iterator();
        while (i.hasNext()) {
            node = (TaskNode)i.next();
            if (node.isTask()) continue;
            Iterator j = reader.getChildrenShortIds(node.getId()).iterator();
            while (j.hasNext()) {
                id = (String)j.next();
                props = reader.getBuffer(id);
                isTask = UIObjectProperties.isTask(props);
                node.addChild(new TaskNode(id, new UIInfo(UIObjectProperties.getName(props), UIObjectProperties.getCaption(props), UIObjectProperties.getImageName(props)), isTask, isTask ? new TaskUrl(id, 2) : null));
            }
            this.buildFullTaskTree(node.getChildren(), reader);
        }
    }

    private List intersectTaskTrees(List nodes1, List nodes2) {
        class QuickSearchTaskNodeList
        extends ArrayList {
            private Map nodeMap;

            public QuickSearchTaskNodeList(List taskNodes) {
                this.nodeMap = new HashMap(taskNodes.size());
                TaskNode node = null;
                Iterator i = taskNodes.iterator();
                while (i.hasNext()) {
                    node = (TaskNode)i.next();
                    this.nodeMap.put(node.getId(), node);
                    this.add(node);
                }
            }

            public TaskNode findNode(String id) {
                return (TaskNode)this.nodeMap.get(id);
            }
        }
        QuickSearchTaskNodeList qsList1 = new QuickSearchTaskNodeList(nodes1);
        QuickSearchTaskNodeList qsList2 = new QuickSearchTaskNodeList(nodes2);
        class DeepCloneTaskNodeList
        extends ArrayList {
            public DeepCloneTaskNodeList(List taskNodes) {
                TaskNode node = null;
                Iterator i = taskNodes.iterator();
                while (i.hasNext()) {
                    node = ((TaskNode)i.next()).getNoChildrenClone();
                    this.add(node);
                }
            }
        }
        DeepCloneTaskNodeList intersection = new DeepCloneTaskNodeList(qsList1);
        intersection.retainAll(qsList2);
        TaskNode node = null;
        Iterator i = intersection.iterator();
        while (i.hasNext()) {
            node = (TaskNode)i.next();
            if (node.isTask()) continue;
            List children = this.intersectTaskTrees(qsList1.findNode(node.getId()).getChildren(), qsList2.findNode(node.getId()).getChildren());
            if (children.isEmpty()) {
                i.remove();
                continue;
            }
            node.addChildren(children);
        }
        return intersection;
    }

    private void setTaskTargets(List taskNodes, List targets, String parent) {
        TaskNode node = null;
        TaskUrl url = null;
        Iterator i = taskNodes.iterator();
        while (i.hasNext()) {
            node = (TaskNode)i.next();
            if (node.isTask()) {
                url = node.getUrl();
                url.setTargets(targets);
                url.setParent(parent);
                continue;
            }
            this.setTaskTargets(node.getChildren(), targets, parent);
        }
    }

    static {
        LOCK = new Object();
    }
}

